% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cste_surv_SCB.R
\name{cste_surv_SCB}
\alias{cste_surv_SCB}
\title{Calculate simultaneous confidence bands (SCB) of CSTE curve for time to event outcome with right censoring.}
\usage{
cste_surv_SCB(l, x, y, z, s, h, m, alpha = 0.05)
}
\arguments{
\item{l}{contraction vector with dimension \eqn{K}.}

\item{x}{samples of biomarker (or covariate) which is a \eqn{n*1} vector 
and should be scaled between 0 and 1.}

\item{y}{samples of time to event which is a \eqn{n*1} vector.}

\item{z}{samples of treatment indicator which is a \eqn{n*K} matrix.}

\item{s}{samples of censoring indicator which is a \eqn{n*1} vector.}

\item{h}{kernel bandwidth.}

\item{m}{number of turns of resampling.}

\item{alpha}{the \eqn{(1-\alpha)}-confidence level of SCB.}
}
\value{
A \eqn{n*3} matrix, estimation of \eqn{l^T \beta(x)} and its simultaneous confidence bands.
}
\description{
This function calculates simultaneous confidence bands of CSTE curve for time to event outcome with right censoring.
}
\references{
Ma Y. and Zhou X. (2017). 
Treatment selection in a randomized clinical trial via covariate-specific 
treatment effect curves, \emph{Statistical Methods in Medical Research}, 26(1), 124-141.
}
\seealso{
\code{\link{cste_surv}}
}
