% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_QuantileMapping.R
\name{CST_QuantileMapping}
\alias{CST_QuantileMapping}
\title{Quantiles Mapping for seasonal or decadal forecast data}
\usage{
CST_QuantileMapping(exp, obs, exp_cor = NULL, sample_dims = c("sdate",
  "ftime", "member"), sample_length = NULL, method = "QUANT",
  ncores = NULL, ...)
}
\arguments{
\item{exp}{an object of class \code{s2dv_cube}}

\item{obs}{an object of class \code{s2dv_cube}}

\item{exp_cor}{an object of class \code{s2dv_cube} in which the quantile mapping correction will be applied. If it is not specified, the correction is applied in object \code{exp}.}

\item{sample_dims}{a character vector indicating the dimensions that can be used as sample for the same distribution}

\item{sample_length}{a numeric value indicating the length of the timeseries window to be used as sample for the sample distribution and correction. By default, NULL, the total length of the timeseries will be used.}

\item{method}{a character string indicating the method to be used: 'PTF','DIST','RQUANT','QUANT','SSPLIN'. By default, the empirical quantile mapping 'QUANT' is used.}

\item{ncores}{an integer indicating the number of parallel processes to spawn for the use for parallel computation in multiple cores.}

\item{...}{additional arguments passed to the method specified by \code{method}.}
}
\value{
an oject of class \code{s2dv_cube} containing the experimental data after applyingthe quantile mapping correction. 
) <- c(dataset = 1, member = 10, sdate = 20, ftime = 60 ,
}
\description{
This function is a wrapper from fitQmap and doQmap from package 'qmap'to be applied in CSTools objects of class 's2dv_cube'. The quantile mapping adjustment between an experiment, tipically a hindcast, and observations is applied to the experiment itself or to a provided forecast.
}
\details{
The different methods are:
\itemize{ 
\item{'PTF'} {fits a parametric transformations to the quantile-quantile relation of observed and modelled values. See \code{\link[qmap]{fitQmapPTF}}.}
\item{'DIST'} {fits a theoretical distribution to observed and to modelled time series. See \code{\link[qmap]{fitQmapDIST}}.}
\item{'RQUANT'} {estimates the values of the quantile-quantile relation of observed and modelled time series for regularly spaced quantiles using local linear least square regression. See \code{\link[qmap]{fitQmapRQUANT}}.}
\item{'QUANT'} {estimates values of the empirical cumulative distribution function of observed and modelled time series for regularly spaced quantiles. See \code{\link[qmap]{fitQmapQUANT}}.}
\item{'SSPLIN'} {fits a smoothing spline to the quantile-quantile plot of observed and modelled time series. See \code{\link[qmap]{fitQmapSSPLIN}}}.}
All methods accepts some common arguments:
\itemize{
\item{wet.day} {logical indicating whether to perform wet day correction or not.(Not available in 'DIS' method)}
\item{qstep} {NULL or a numeric value between 0 and 1.}}
}
\examples{
library(qmap)
exp <- 1 : (1 * 5 * 10 * 6 * 2 * 3)
dim(exp) <- c(dataset = 1, member = 10, sdate = 5, ftime = 6 , 
             lat = 2, lon = 3)
exp <- list(data = exp)
class(exp) <- 's2dv_cube'
obs <- 101 : (100 + 1 * 1 * 5 * 6 * 2 * 3)
dim(obs) <- c(dataset = 1, member = 1, sdate = 5, ftime = 6 ,
             lat = 2, lon = 3)
obs <- list(data = obs)
class(obs) <- 's2dv_cube'
res <- CST_QuantileMapping(exp, obs, method = 'RQUANT')
\donttest{
exp <- lonlat_data$exp
obs <- lonlat_data$obs
res <- CST_QuantileMapping(exp, obs)

data(obsprecip)
data(modprecip)
exp <- modprecip$MOSS[1:10000]
dim(exp) <- c(time = length(exp))
exp <- list(data = exp)
class(exp) <- 's2dv_cube'
obs <- obsprecip$MOSS[1:10000]
dim(obs) <- c(time = length(obs))
obs <- list(data = obs)
class(obs) <- 's2dv_cube'
res <- CST_QuantileMapping(exp = exp, obs = obs, sample_dims = 'time',
                          method = 'DIST')
}
}
\author{
Nuria Perez-Zanon, \email{nuria.perez@bsc.es}
}
\seealso{
\code{\link[qmap]{fitQmap}} and \code{\link[qmap]{doQmap}}
}

