% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{mlqqplot}
\alias{mlqqplot}
\title{Mittag-Leffler QQ Plot}
\usage{
mlqqplot(x, tail = 1, scale = NULL, ...)
}
\arguments{
\item{x}{A vector of data to be compared against the Mittag-Leffler
distribution.}

\item{tail}{Tail parameter of the Mittag-Leffler population. Default is
\code{1}, i.e. the exponential distribution.}

\item{scale}{Scale parameter of the Mittag-Leffler population, if known.}

\item{...}{Additional plotting arguments, e.g. \code{log = 'xy'}.}
}
\description{
Generates a QQ plot for assessing the fit of a Mittag-Leffler
distribution.
}
\examples{
  library(magrittr)
  flares \%>\% ctre() \%>\% thin(k=200) \%>\% interarrival() \%>\% mlqqplot(tail = 1, log = 'xy')
  flares \%>\% ctre() \%>\% thin(k=200) \%>\% interarrival() \%>\% mlqqplot(tail = 0.8, log = 'xy')

  seaquakes \%>\% ctre() \%>\% thin(k=150) \%>\% interarrival() \%>\% mlqqplot(tail = 0.9, log = 'xy')
}
