% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inigrid.R
\name{inigrid}
\alias{inigrid}
\title{Grid-based preliminary parameter estimates for CUB models}
\usage{
inigrid(m,freq,x,y)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{freq}{Vector of length \eqn{m} of the absolute frequency distribution}

\item{x}{A set of values to assign to the uncertainty parameter \eqn{\pi}}

\item{y}{A set of values to assign to the feeling parameter \eqn{\xi}}
}
\value{
It returns the parameter vector corresponding to the maximum value of the log-likelihood 
for a CUB model without covariates for given frequencies.
}
\description{
Compute the log-likelihood function of a CUB model with parameter vector \eqn{(\pi, \xi)} ranging in
the Cartesian product between \eqn{x} and \eqn{y}, for a given absolute frequency distribution.
}
\examples{
m<-9
x<-c(0.1,0.4,0.6,0.8)
y<-c(0.2, 0.5,0.7)
freq<-c(10,24,28,36,50,43,23,12,5)
ini<-inigrid(m,freq,x,y)
pai<-ini[1]
csi<-ini[2]
}
\seealso{
\code{\link{inibest}}
}
\keyword{htest}
\keyword{utilities}

