% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicube.R
\name{multicube}
\alias{multicube}
\title{Joint plot of estimated CUBE models in the parameter space}
\usage{
multicube(listord, ...)
}
\arguments{
\item{listord}{List of vectors of ordinal observations, possibly with different lengths and over different
numbers of categories}

\item{...}{Additional arguments to be passed to \code{\link{plot}}, \code{\link{text}}, and \code{\link{GEM}}}
}
\description{
Return a plot of estimated CUBE models represented as points in the
 parameter space, where the overdispersion is labeled.
}
\examples{
m1<-5; m2<-7;  m3<-9
pai<-0.7;csi<-0.6;phi=0.1
n1<-1000; n2<-500; n3<-1500
ord1<-factor(simcube(n1,m1,pai,csi,phi),ordered=TRUE)
ord2<-factor(simcube(n2,m2,pai,csi,phi),ordered=TRUE)
ord3<-factor(simcube(n3,m3,pai,csi,phi),ordered=TRUE)
listord<-list(ord1,ord2,ord3)
multicube(listord,labels=c("m=5","m=7","m=9"),pos=c(3,1,4),expinform=TRUE)
}
\keyword{device}

