% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcub.R
\name{simcub}
\alias{simcub}
\title{Simulation routine for CUB models}
\usage{
simcub(n,m,pai,csi)
}
\arguments{
\item{n}{Number of simulated observations}

\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}
}
\description{
Generate \eqn{n} pseudo-random observations following the given CUB distribution.
}
\examples{
n<-300
m<-9
pai<-0.4
csi<-0.7
simulation<-simcub(n,m,pai,csi)
plot(table(simulation),xlab="Ordinal categories",ylab="Frequencies")
}
\seealso{
\code{\link{probcub00}}
}
\keyword{distribution}
