% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{quad_form}
\alias{quad_form}
\title{Quadratic Form}
\usage{
quad_form(x, P)
}
\arguments{
\item{x}{An \linkS4class{Expression} or vector.}

\item{P}{An \linkS4class{Expression} or matrix.}
}
\value{
An \linkS4class{Expression} representing the quadratic form evaluated at the input.
}
\description{
The quadratic form, \eqn{x^TPx}.
}
\examples{
x <- Variable(2)
P <- rbind(c(4,0), c(0,9))
prob <- Problem(Minimize(quad_form(x,P)), list(x >= 1))
result <- solve(prob)
result$value
result$getValue(x)

A <- Variable(2,2)
c <- c(1,2)
prob <- Problem(Minimize(quad_form(c,A)), list(A >= 1))
result <- solve(prob)
result$value
result$getValue(A)
}
