% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R
\docType{class}
\name{Leaf-class}
\alias{Leaf-class}
\alias{Leaf}
\alias{variables,Leaf-method}
\alias{parameters,Leaf-method}
\alias{constants,Leaf-method}
\alias{is_convex,Leaf-method}
\alias{is_concave,Leaf-method}
\alias{is_quadratic,Leaf-method}
\alias{is_pwl,Leaf-method}
\alias{domain,Leaf-method}
\alias{validate_val,Leaf-method}
\title{The Leaf class.}
\usage{
\S4method{variables}{Leaf}(object)

\S4method{parameters}{Leaf}(object)

\S4method{constants}{Leaf}(object)

\S4method{is_convex}{Leaf}(object)

\S4method{is_concave}{Leaf}(object)

\S4method{is_quadratic}{Leaf}(object)

\S4method{is_pwl}{Leaf}(object)

\S4method{domain}{Leaf}(object)

\S4method{validate_val}{Leaf}(object, val)
}
\arguments{
\item{object}{A \linkS4class{Leaf} object.}

\item{val}{The assigned value.}
}
\description{
This class represents a leaf node, i.e. a Variable, Constant, or Parameter.
}
\section{Methods (by generic)}{
\itemize{
\item \code{variables}: List of \linkS4class{Variable} objects in the leaf node.

\item \code{parameters}: List of \linkS4class{Parameter} objects in the leaf node.

\item \code{constants}: List of \linkS4class{Constant} objects in the leaf node.

\item \code{is_convex}: A logical value indicating whether the leaf node is convex.

\item \code{is_concave}: A logical value indicating whether the leaf node is concave.

\item \code{is_quadratic}: A logical value indicating whether the leaf node is quadratic.

\item \code{is_pwl}: A logical value indicating whether the leaf node is piecewise linear.

\item \code{domain}: A list of constraints describing the closure of the region where the leaf node is finite. Default is the full domain.

\item \code{validate_val}: Check that \code{val} satisfies symbolic attributes of leaf.
}}

\section{Slots}{

\describe{
\item{\code{args}}{A list containing the arguments.}
}}

