% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{LambdaMax-class}
\alias{LambdaMax-class}
\alias{.LambdaMax}
\alias{LambdaMax}
\alias{to_numeric,LambdaMax-method}
\alias{.domain,LambdaMax-method}
\alias{.grad,LambdaMax-method}
\alias{validate_args,LambdaMax-method}
\alias{dim_from_args,LambdaMax-method}
\alias{sign_from_args,LambdaMax-method}
\alias{is_atom_convex,LambdaMax-method}
\alias{is_atom_concave,LambdaMax-method}
\alias{is_incr,LambdaMax-method}
\alias{is_decr,LambdaMax-method}
\title{The LambdaMax class.}
\usage{
LambdaMax(A)

\S4method{to_numeric}{LambdaMax}(object, values)

\S4method{.domain}{LambdaMax}(object)

\S4method{.grad}{LambdaMax}(object, values)

\S4method{validate_args}{LambdaMax}(object)

\S4method{dim_from_args}{LambdaMax}(object)

\S4method{sign_from_args}{LambdaMax}(object)

\S4method{is_atom_convex}{LambdaMax}(object)

\S4method{is_atom_concave}{LambdaMax}(object)

\S4method{is_incr}{LambdaMax}(object, idx)

\S4method{is_decr}{LambdaMax}(object, idx)
}
\arguments{
\item{A}{An \linkS4class{Expression} or numeric matrix.}

\item{object}{A \linkS4class{LambdaMax} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}
}
\description{
The maximum eigenvalue of a matrix, \eqn{\lambda_{\max}(A)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The largest eigenvalue of \code{A}. Requires that \code{A} be symmetric.

\item \code{.domain}: Returns the constraints describing the domain of the atom.

\item \code{.grad}: Gives the (sub/super)gradient of the atom with respect to each argument. Matrix expressions are vectorized, so the gradient is a matrix.

\item \code{validate_args}: Check that \code{A} is square.

\item \code{dim_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The sign of the atom is unknown.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is not monotonic in any argument.

\item \code{is_decr}: The atom is not monotonic in any argument.
}}

\section{Slots}{

\describe{
\item{\code{A}}{An \linkS4class{Expression} or numeric matrix.}
}}

