% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{methods}
\name{unpack_results}
\alias{unpack_results}
\title{Parse output from a solver and updates problem state}
\usage{
unpack_results(object, solution, chain, inverse_data)
}
\arguments{
\item{object}{A \linkS4class{Problem} object.}

\item{solution}{A \linkS4class{Solution} object.}

\item{chain}{The corresponding solving \linkS4class{Chain}.}

\item{inverse_data}{A \linkS4class{InverseData} object or list containing data necessary for the inversion.}
}
\value{
A list containing the solution to the problem:
\describe{
   \item{\code{status}}{The status of the solution. Can be "optimal", "optimal_inaccurate", "infeasible", "infeasible_inaccurate", "unbounded", "unbounded_inaccurate", or "solver_error".}
   \item{\code{value}}{The optimal value of the objective function.}
   \item{\code{solver}}{The name of the solver.}
   \item{\code{solve_time}}{The time (in seconds) it took for the solver to solve the problem.}
   \item{\code{setup_time}}{The time (in seconds) it took for the solver to set up the problem.}
   \item{\code{num_iters}}{The number of iterations the solver had to go through to find a solution.}
   \item{\code{getValue}}{A function that takes a \linkS4class{Variable} object and retrieves its primal value.}
   \item{\code{getDualValue}}{A function that takes a \linkS4class{Constraint} object and retrieves its dual value(s).}
}
}
\description{
Updates problem status, problem value, and primal and dual variable values
}
\examples{
\dontrun{
x <- Variable(2)
obj <- Minimize(x[1] + cvxr_norm(x, 1))
constraints <- list(x >= 2)
prob1 <- Problem(obj, constraints)
# Solve with ECOS.
ecos_data <- get_problem_data(prob1, "ECOS")
# Call ECOS solver interface directly
ecos_output <- ECOSolveR::ECOS_csolve(
                           c = ecos_data[["c"]],
                           G = ecos_data[["G"]],
                           h = ecos_data[["h"]],
                           dims = ecos_data[["dims"]],
                           A = ecos_data[["A"]],
                           b = ecos_data[["b"]]
                         )
# Unpack raw solver output.
res1 <- unpack_results(prob1, "ECOS", ecos_output)
# Without DCP validation (so be sure of your math), above is equivalent to:
# res1 <- solve(prob1, solver = "ECOS")
X <- Variable(2,2, PSD = TRUE)
Fmat <- rbind(c(1,0), c(0,-1))
obj <- Minimize(sum_squares(X - Fmat))
prob2 <- Problem(obj)
scs_data <- get_problem_data(prob2, "SCS")
scs_output <- scs::scs(
                      A = scs_data[['A']],
                      b = scs_data[['b']],
                      obj = scs_data[['c']],
                      cone = scs_data[['dims']]
                  )
res2 <- unpack_results(prob2, "SCS", scs_output)
# Without DCP validation (so be sure of your math), above is equivalent to:
# res2 <- solve(prob2, solver = "SCS")
}
}
