% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\docType{class}
\name{ConicSolver-class}
\alias{ConicSolver-class}
\alias{ConicSolver}
\alias{accepts,ConicSolver,Problem-method}
\alias{reduction_format_constr,ConicSolver-method}
\alias{group_coeff_offset,ConicSolver-method}
\alias{invert,ConicSolver,Solution,InverseData-method}
\title{The ConicSolver class.}
\usage{
\S4method{accepts}{ConicSolver,Problem}(object, problem)

\S4method{reduction_format_constr}{ConicSolver}(object, problem, constr, exp_cone_order)

\S4method{group_coeff_offset}{ConicSolver}(object, problem, constraints, exp_cone_order)

\S4method{invert}{ConicSolver,Solution,InverseData}(object, solution, inverse_data)
}
\arguments{
\item{object}{A \linkS4class{ConicSolver} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{constr}{A \linkS4class{Constraint} to format.}

\item{exp_cone_order}{A list indicating how the exponential cone arguments are ordered.}

\item{constraints}{A list of \linkS4class{Constraint} objects.}

\item{solution}{A \linkS4class{Solution} object to invert.}

\item{inverse_data}{A \linkS4class{InverseData} object containing data necessary for the inversion.}
}
\description{
Conic solver class with reduction semantics.
}
\section{Methods (by generic)}{
\itemize{
\item \code{accepts}: Can the problem be solved with a conic solver?

\item \code{reduction_format_constr}: Return a list representing a cone program whose problem data tensors
will yield the coefficient "A" and offset "b" for the respective constraints:
Linear Equations: A %*% x == b,
Linear inequalities: A %*% x <= b,
Second order cone: A %*% x <=_{SOC} b,
Exponential cone: A %*% x <=_{EXP} b,
Semidefinite cone: A %*% x <=_{SOP} b.

\item \code{group_coeff_offset}: Combine the constraints into a single matrix, offset.

\item \code{invert}: Returns the solution to the original problem given the inverse_data.
}}

