% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{curvature-methods}
\alias{curvature-methods}
\alias{is_constant}
\alias{is_affine}
\alias{is_convex}
\alias{is_concave}
\alias{is_quadratic}
\alias{is_pwl}
\alias{is_qpwa}
\title{Curvature Properties}
\usage{
is_constant(object)

is_affine(object)

is_convex(object)

is_concave(object)

is_quadratic(object)

is_pwl(object)

is_qpwa(object)
}
\arguments{
\item{object}{An \linkS4class{Expression} object.}
}
\value{
A logical value.
}
\description{
Determine if an expression is constant, affine, convex, concave, quadratic, piecewise linear (pwl), or quadratic/piecewise affine (qpwa).
}
\examples{
x <- Variable()
c <- Constant(5)

is_constant(c)
is_constant(x)

is_affine(c)
is_affine(x)
is_affine(x^2)

is_convex(c)
is_convex(x)
is_convex(x^2)
is_convex(sqrt(x))

is_concave(c)
is_concave(x)
is_concave(x^2)
is_concave(sqrt(x))

is_quadratic(x^2)
is_quadratic(sqrt(x))

is_pwl(c)
is_pwl(x)
is_pwl(x^2)
}
