% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{geo_mean}
\alias{geo_mean}
\title{Geometric Mean}
\usage{
geo_mean(x, p = NA_real_, max_denom = 1024)
}
\arguments{
\item{x}{An \linkS4class{Expression} or vector.}

\item{p}{(Optional) A vector of weights for the weighted geometric mean. Defaults to a vector of ones, giving the \strong{unweighted} geometric mean \eqn{x_1^{1/n} \cdots x_n^{1/n}}.}

\item{max_denom}{(Optional) The maximum denominator to use in approximating \code{p/sum(p)} with \code{w}. If \code{w} is not an exact representation, increasing \code{max_denom} may offer a more accurate representation, at the cost of requiring more convex inequalities to represent the geometric mean. Defaults to 1024.}
}
\value{
An \linkS4class{Expression} representing the geometric mean of the input.
}
\description{
The (weighted) geometric mean of vector \eqn{x} with optional powers given by \eqn{p}.
}
\details{
\deqn{\left(x_1^{p_1} \cdots x_n^{p_n} \right)^{\frac{1}{\mathbf{1}^Tp}}}

The geometric mean includes an implicit constraint that \eqn{x_i \geq 0} whenever \eqn{p_i > 0}. If \eqn{p_i = 0, x_i} will be unconstrained.
The only exception to this rule occurs when \eqn{p} has exactly one nonzero element, say \eqn{p_i}, in which case \code{geo_mean(x,p)} is equivalent to \eqn{x_i} (without the nonnegativity constraint).
A specific case of this is when \eqn{x \in \mathbf{R}^1}.
}
\examples{
x <- Variable(2)
cost <- geo_mean(x)
prob <- Problem(Maximize(cost), list(sum(x) <= 1))
result <- solve(prob)
result$value
result$getValue(x)

\dontrun{
  x <- Variable(5)
  p <- c(0.07, 0.12, 0.23, 0.19, 0.39)
  prob <- Problem(Maximize(geo_mean(x,p)), list(p_norm(x) <= 1))
  result <- solve(prob)
  result$value
  result$getValue(x)
}
}
