% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVE.R
\docType{package}
\name{CVarE-package}
\alias{CVarE}
\alias{CVarE-package}
\title{Conditional Variance Estimator (CVE) Package.}
\description{
Conditional Variance Estimation (CVE) is a novel sufficient dimension
reduction (SDR) method for regressions satisfying \eqn{E(Y|X) = E(Y|B'X)},
where \eqn{B'X} is a lower dimensional projection of the predictors and
\eqn{Y} is a univariate response. CVE,
similarly to its main competitor, the mean average variance estimation
(MAVE), is not based on inverse regression, and does not require the
restrictive linearity and constant variance conditions of moment based SDR
methods. CVE is data-driven and applies to additive error regressions with
continuous predictors and link function. Let \eqn{X} be a real
\eqn{p}-dimensional covariate vector. We assume that the dependence of
\eqn{Y} and \eqn{X} is modelled by
}
\details{
\deqn{Y = g(B'X) + \epsilon}

where \eqn{X} is independent of \eqn{\epsilon} with positive definite
variance-covariance matrix \eqn{Var(X) = \Sigma_X}. \eqn{\epsilon} is a mean
zero random variable with finite \eqn{Var(\epsilon) = E(\epsilon^2)}, \eqn{g}
is an unknown, continuous non-constant function,
and \eqn{B = (b_1, ..., b_k)} is
a real \eqn{p \times k}{p x k} matrix of rank \eqn{k \leq p}{k <= p}. 
Without loss of generality \eqn{B} is assumed to be orthonormal.

Further, the extended Ensemble Conditional Variance Estimation (ECVE) is
implemented which is a SDR method in regressions with continuous response and
predictors. ECVE applies to general non-additive error regression models.

\deqn{Y = g(B'X, \epsilon)}

It operates under the assumption that the predictors can be replaced by a
lower dimensional projection without loss of information.It is a
semiparametric forward regression model based exhaustive sufficient dimension
reduction estimation method that is shown to be consistent under mild
assumptions.
}
\references{
[1] Fertl, L. and Bura, E. (2021) "Conditional Variance
         Estimation for Sufficient Dimension Reduction"
         <arXiv:2102.08782>

   [2] Fertl, L. and Bura, E. (2021) "Ensemble Conditional Variance
         Estimation for Sufficient Dimension Reduction"
         <arXiv:2102.13435>
}
\seealso{
Useful links:
\itemize{
  \item \url{https://git.art-ist.cc/daniel/CVE}
}

}
\author{
Daniel Kapla, Lukas Fertl, Bura Efstathia
}
