% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJ.R
\name{Carlson_RJ}
\alias{Carlson_RJ}
\title{Carlson elliptic integral RJ}
\usage{
Carlson_RJ(x, y, z, p, minerror = 1e-15)
}
\arguments{
\item{x, y, z, p}{real or complex numbers; at most one can be 0}

\item{minerror}{bound on the relative error}
}
\value{
A complex number, the value of the Carlson elliptic integral
  \ifelse{html}{\out{R<sub>J</sub>(x,y,z,t)}}{\eqn{R_J(x,y,z,t)}{RJ(x,y,z,t)}}.
}
\description{
Evaluate the Carlson elliptic integral RJ.
}
\note{
The function returns a value when \code{x}, \code{y}, \code{z} or
  \code{p} are negative real numbers, but this value is not the one of the
  Carlson integral.
}
\examples{
Carlson_RJ(5, 2, 3, 4)
gsl::ellint_RJ(5, 2, 3, 4)
}
