% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pseudo_pop.R
\name{generate_pseudo_pop}
\alias{generate_pseudo_pop}
\title{Generate Pseudo Population}
\usage{
generate_pseudo_pop(
  Y,
  w,
  c,
  ci_appr,
  pred_model,
  gps_model = "parametric",
  use_cov_transform = FALSE,
  transformers = list("pow2", "pow3"),
  bin_seq = NULL,
  trim_quantiles = c(0.01, 0.99),
  optimized_compile = FALSE,
  params = list(),
  nthread = 1,
  ...
)
}
\arguments{
\item{Y}{A vector of observed outcome variable.}

\item{w}{A vector of observed continuous exposure variable.}

\item{c}{A data.frame or matrix of observed covariates variable.}

\item{ci_appr}{The causal inference approach. Possible values are:
\itemize{
\item "matching": Matching by GPS
\item "weighting": Weighting by GPS
\item "adjusting": Adjusting by GPS
}}

\item{pred_model}{a prediction model (use "sl" for SuperLearner)}

\item{gps_model}{Model type which is used for estimating GPS value, including
parametric (default) and non-parametric.}

\item{use_cov_transform}{If TRUE, the function uses transformer to meet the
covariate balance.}

\item{transformers}{A list of transformers. Each transformer should be a
unary function. You can pass name of customized function in the quotes.
Available transformers:
\itemize{
\item pow2: to the power of 2
\item pow3: to the power of 3
}}

\item{bin_seq}{Sequence of w (treatment) to generate pseudo population. If
NULL is passed the default value will be used, which is
\code{seq(min(w)+delta_n/2,max(w), by=delta_n)}.}

\item{trim_quantiles}{A numerical vector of two. Represents the trim quantile
level. Both numbers should be in the range of [0,1] and in increasing order
(default: c(0.01,0.99)).}

\item{optimized_compile}{If TRUE, uses counts to keep track of number of
replicated pseudo population.}

\item{params}{Includes list of params that is used internally. Unrelated
parameters will be ignored.}

\item{nthread}{An integer value that represents the number of threads to be
used by internal packages.}

\item{...}{Additional arguments passed to different models.}
}
\value{
Returns a pseudo population (gpsm_pspop) object that is generated
or augmented based on the selected causal inference approach (ci_appr). The
object includes the following objects:
\itemize{
\item params
\itemize{
\item ci_appr
\item pred_model
\item params
}
\item pseudo_pop
\item adjusted_corr_results
\item original_corr_results
\item optimized_compile (True or False)
}
}
\description{
Generates pseudo population data set based on user-defined causal inference
approach. The function uses an adaptive approach to satisfies covariate
balance requirements. The function terminates either by satisfying covariate
balance or completing the requested number of iteration, whichever comes
first.
}
\details{
\subsection{Additional parameters}{
\subsection{Causal Inference Approach (ci.appr)}{
\itemize{
\item if ci.appr = 'matching':
\itemize{
\item \emph{matching_fun}: Matching function. Available options:
\itemize{
\item matching_l1: Manhattan distance matching
}
\item \emph{delta_n}: caliper parameter.
\item \emph{scale}: a specified scale parameter to control the relative weight that
is attributed to the distance measures of the exposure versus the GPS.
\item \emph{covar_bl_method}: covariate balance method. Available options:
\itemize{
\item 'absolute'
}
\item \emph{covar_bl_trs}: covariate balance threshold
\item \emph{covar_bl_trs_type}: covariate balance type (mean, median, maximal)
\item \emph{max_attempt}: maximum number of attempt to satisfy covariate balance.
\item See \code{\link[=create_matching]{create_matching()}} for more details about the parameters and default
values.
}
\item if ci.appr = 'weighting':
\itemize{
\item \emph{covar_bl_method}: Covariate balance method.
\item \emph{covar_bl_trs}: Covariate balance threshold
\item \emph{max_attempt}: Maximum number of attempt to satisfy covariate balance.
}
}
}

\subsection{Prediction models (pred_model)}{
\itemize{
\item if pred_model = 'sl':
\itemize{
\item \emph{sl_lib}: A vector of prediction algorithms.
}
}
}

}
}
\examples{
m_d <- generate_syn_data(sample_size = 100)
pseuoo_pop <- generate_pseudo_pop(m_d$Y,
                                  m_d$treat,
                                  m_d[c("cf1","cf2","cf3","cf4","cf5","cf6")],
                                  ci_appr = "matching",
                                  pred_model = "sl",
                                  gps_model = "parametric",
                                  bin_seq = NULL,
                                  trim_quantiles = c(0.01,0.99),
                                  optimized_compile = FALSE,
                                  use_cov_transform = FALSE,
                                  transformers = list(),
                                  sl_lib = c("m_xgboost"),
                                  params = list(xgb_nrounds=c(10,20,30),
                                                xgb_eta=c(0.1,0.2,0.3)),
                                  nthread = 1,
                                  covar_bl_method = "absolute",
                                  covar_bl_trs = 0.1,
                                  covar_bl_trs_type= "mean",
                                  max_attempt = 1,
                                  matching_fun = "matching_l1",
                                  delta_n = 1,
                                  scale = 0.5)

}
