% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_confounds_df.R
\name{set_confounds_df}
\alias{set_confounds_df}
\title{Set a confounds_df}
\usage{
set_confounds_df(model)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}
}
\value{
An object of class \code{causal_model}. It essentially returns a list containing the elements comprising
a model (e.g. 'statement', 'nodal_types' and 'DAG') with the confound_df attached to the parameter matrix in the model.
}
\description{
Normally a confounds_df is added to a model whenever confounding is set.
The confounds_df can be manually provided however using set_confounds_df.
}
\examples{
\donttest{
model <- make_model('X -> Y') \%>\%
  set_confound(list('X <-> Y'), add_confounds_df = FALSE)
model$confounds_df
set_confounds_df(model)$confounds_df

# An example where a restriction is applied after a confounding relation is set removes
model <- make_model('X -> Y') \%>\%
  set_confound(list(X = '(Y[X=1] > Y[X=0])')) \%>\%
  set_restrictions('(Y[X=1] > Y[X=0])')
}
}
