% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov_pcaSpectra.R
\name{aov_pcaSpectra}
\alias{aov_pcaSpectra}
\title{ANOVA-PCA Analysis of Spectra Data}
\usage{
aov_pcaSpectra(spectra, fac, type = "class", choice = NULL, showNames = TRUE)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{fac}{A vector of character strings giving the factors to be used in
the analysis.  These should be elements of \code{\link{Spectra}}.  Note that
there should be 2 or more factors, because ANOVA-PCA on one factor is the
same as standard PCA.  See the example.}

\item{type}{Either classical ("cls") or robust ("rob"); Results in either
\code{\link{c_pcaSpectra}} or \code{\link{r_pcaSpectra}} being called on the
\code{\link{Spectra}} object.}

\item{choice}{The type of scaling to be performed.  See
\code{\link{c_pcaSpectra}} and \code{\link{r_pcaSpectra}} for details.}

\item{showNames}{Logical.  Show the names of the submatrices in the console.}
}
\value{
A list of PCA results, one for each computed submatrix.
}
\description{
ANOVA-PCA is a combination of both methods developed by Harrington.  The
data is partitioned into submatrices corresponding to each experimental
factor, which are then subjected to PCA separately after adding the residual
error back.  If the effect of a factor is large compared to the residual
error, separation along the 1st PC in the score plot should be evident.
With this method, the significance of a factor can be visually determined
(ANOVA-PCA is not blind to group membership). ANOVA-PCA with only one factor
is the same as standard PCA and gives no additional separation.
}
\examples{

\dontrun{
# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(metMUD2)

# Original factor encoding:
levels(metMUD2$groups)

# Split those original levels into 2 new ones (re-code them)
new.grps <- list(geneBb = c("B", "b"), geneCc = c("C", "c"))
mM3 <- splitSpectraGroups(metMUD2, new.grps)

# run aov_pcaSpectra
PCAs <- aov_pcaSpectra(mM3, fac = c("geneBb", "geneCc"))

p1 <- aovPCAscores(mM3, PCAs, submat = 1, ellipse = "cls")
p1 <- p1 + ggtitle("aovPCA: B vs b")
p1

p2 <- aovPCAscores(mM3, PCAs, submat = 2)
p2 <- p2 + ggtitle("aovPCA: C vs c")
p2

p3 <- aovPCAscores(mM3, PCAs, submat = 3)
p3 <- p3 + ggtitle("aovPCA: Interaction Term")
p3

p4 <- aovPCAloadings(spectra = mM3, PCA = PCAs)
p4 <- p4 + ggtitle("aov_pcaSpectra: Bb Loadings")
p4
}
}
\references{
Pinto, Bosc, Nocairi, Barros, and Rutledge. "Using ANOVA-PCA for
Discriminant Analysis: ..." Analytica Chimica Acta 629.1-2 (2008): 47-55.

Harrington, Vieira, Espinoza, Nien, Romero, and Yergey. "Analysis of
Variance--Principal Component Analysis: ..." Analytica Chimica Acta 544.1-2
(2005): 118-27.
}
\seealso{
The output of this function is used in
used in \code{\link{aovPCAscores}} and \code{\link{aovPCAloadings}}.
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Matthew J. Keinsley.
}
\keyword{htest}
\keyword{multivariate}
