% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_restriction.R
\name{heat_restriction}
\alias{heat_restriction}
\title{Heat Restriction model}
\usage{
heat_restriction(x, model, nh, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{model}{Model to be used for calculation. Use "utah" for Utah Model and "nc" for North Carolina Model.}

\item{nh}{Number of hours of continuous heat.}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill-unit for each temperature (TRUE is default).}
}
\value{
The function returns values the chill-units for each temperature of vector (Total = FALSE), or returns the chill-units accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation by Utah Model and North Carolina Model.
}
\details{
The model is based on chill-units (Utah Model or North Carolina Model). After a certain number of hours of heat, the counting the negative units is interrupted. Negativation of the cold by the heat is restricted to a few days, 24h for Raseira (1982), 96h for Ebert (1986), 30 hours for Fishmann (1987) and 36 hours for Anzanello (2012).
}
\examples{

x <- rnorm(500, 15, 5)

#5 hours of heat to stop counting the negative units.
heat_restriction(x, model = "nc",nh = 5)

#24 hours of heat to stop counting the negative units.
heat_restriction(x, model = "nc", nh = 24)

}
