% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{given_name_df}
\alias{given_name_df}
\title{Chinese Given Name Characters and Frequency (1930–2008)}
\format{
A data frame with 2614 observations and 25 variables:
\describe{
  \item{character}{Chinese character used in given names (character)}
  \item{pinyin}{Pronunciation in Pinyin (character)}
  \item{bihua}{Number of strokes in the character (numeric)}
  \item{n.male}{Number of males with this character in their name (numeric)}
  \item{n.female}{Number of females with this character in their name (numeric)}
  \item{name.gender}{Gender index (numeric)}
  \item{n.1930_1959}{Number of occurrences between 1930–1959 (numeric)}
  \item{n.1960_1969}{Number of occurrences between 1960–1969 (numeric)}
  \item{n.1970_1979}{Number of occurrences between 1970–1979 (numeric)}
  \item{n.1980_1989}{Number of occurrences between 1980–1989 (numeric)}
  \item{n.1990_1999}{Number of occurrences between 1990–1999 (numeric)}
  \item{n.2000_2008}{Number of occurrences between 2000–2008 (numeric)}
  \item{ppm.1930_1959}{Frequency per million (1930–1959) (numeric)}
  \item{ppm.1960_1969}{Frequency per million (1960–1969) (numeric)}
  \item{ppm.1970_1979}{Frequency per million (1970–1979) (numeric)}
  \item{ppm.1980_1989}{Frequency per million (1980–1989) (numeric)}
  \item{ppm.1990_1999}{Frequency per million (1990–1999) (numeric)}
  \item{ppm.2000_2008}{Frequency per million (2000–2008) (numeric)}
  \item{name.ppm}{Overall frequency per million (numeric)}
  \item{name.uniqueness}{Uniqueness score of the name (numeric)}
  \item{corpus.ppm}{Frequency in linguistic corpus (numeric)}
  \item{corpus.uniqueness}{Uniqueness in corpus (numeric)}
  \item{name.valence}{Emotional valence of the name (numeric)}
  \item{name.warmth}{Perceived warmth of the name (numeric)}
  \item{name.competence}{Perceived competence of the name (numeric)}
}
}
\source{
Data taken from the ChineseNames package version 2023.8
}
\usage{
data(given_name_df)
}
\description{
This dataset, given_name_df, is a data frame containing 2,614 Chinese characters commonly used
in given names, along with nationwide frequency data. The dataset includes 2614 observations and
25 variables, providing information such as stroke count, gender distribution, historical usage,
frequency per million, uniqueness, and perceived name traits such as warmth and competence.
}
\details{
The dataset name has been kept as 'given_name_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChinAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
