\name{GetDescendantEdges}

\alias{GetDescendantEdges}

\title{
Gets descendant edges of an internal node
}

\description{
Returns all descendant edges of an internal node for a phylo object.
}

\usage{
GetDescendantEdges(n, tree)
}

\arguments{
\item{n}{An integer corresponding to the internal node for which the descendant edges are sought.}
\item{tree}{A tree as a phylo object.}
}

\details{
Returns a vector of integers corresponding to row numbers in \code{$edge} or cells in \code{$edge.length} of the descendant edges of the internal node supplied.
}

\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}

\examples{
# Create simple four-taxon tree:
tree <- read.tree(text="(A,(B,(C,D)));")

# Plot tree:
plot(tree)

# Add nodelabels:
nodelabels()

# Add edgelabels (note that edges 5 and 6
# are descendants of node 7):
edgelabels()

# Use GdtDescendantEdges to show that edges
# 5 and 6 are descendants of node 7:
GetDescendantEdges(7, tree)
}
