% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindAncestor.R
\name{FindAncestor}
\alias{FindAncestor}
\title{Find ancestor}
\usage{
FindAncestor(descs, tree)
}
\arguments{
\item{descs}{A vector of mode character representing the tip names for which an ancestor is sought.}

\item{tree}{The tree as a phylo object.}
}
\value{
\item{anc.node}{The ancestral node number.}
}
\description{
Finds the last common ancestor (node) of a set of two or more descendant tips.
}
\details{
Intended for use as an internal function for \link{TrimMorphDistMatrix}, but potentially of more general use.
}
\examples{

# Create a simple four-taxon tree:
tree <- read.tree(text = "(A,(B,(C,D)));")

# Plot the tree:
plot(tree)

# Add nodelabels and show that the most recent common
# ancestor of B, C, and D is node 6:
nodelabels()

# Use FindAncestor to show that the most recent common
# ancestor of B, C, and D is node 6:
FindAncestor(c("B", "C", "D"), tree)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
\keyword{ancestor}
