% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClimDown.R
\name{options}
\alias{options}
\title{User-configurable options}
\arguments{
\item{max.GB}{An \emph{approximate} measure of how much RAM to use in
the chunk I/O loop. In reality, R does a lot of copying data,
so if you have a firm RAM threshold, it's best to set this to
about 1/3 to 1/4 of what you want the high-water mark to
be. (default=1)}

\item{trimmed.mean}{Undocumented and not recommended to
change. (default=0)}

\item{delta.days}{Undocumented and not recommended to
change. (default=45)}

\item{n.analogues}{The number of temporal analogues that the CA
algorithm will search for and match. The higher this number,
the longer the execution time of the reordering
step. (default=30)}

\item{calibration.start}{A POSIXct object that defines the
beginning of the calibration period. \cr
(default=\code{as.POSIXct('1971-01-01', tz='GMT')})}

\item{calibration.end}{A POSIXct object that defines the end of the
calibration period. \cr
(default=\code{as.POSIXct('2005-12-31', tz='GMT')})}

\item{tol}{Undocumented and not recommended to
change. (default=0.1)}

\item{expon}{Undocumented and not recommended to
change. (default=0.5)}

\item{multiyear}{Undocumented and not recommended to
change. (default=TRUE)}

\item{expand.multiyear}{Undocumented and not recommended to
change. (default=TRUE)}

\item{multiyear.window.length}{Undocumented and not recommended to
change. (default=30)}

\item{trace}{Undocumented and not recommended to
change. (default=0.005)}

\item{jitter.factor}{Undocumented and not recommended to
change. (default=0.01)}

\item{tau}{Undocumented and not recommended to change. \cr
(default=\code{list(pr=1001, tasmax=101, tasmin=101)})}

\item{seasonal}{Undocumented and not recommended to change. \cr
(default=\code{list(pr=TRUE, tasmax=FALSE, tasmin=FALSE)})}

\item{ratio}{Undocumented and not recommended to change. \cr
(default=\code{list(pr=TRUE, tasmax=FALSE, tasmin=FALSE)})}

\item{check.units}{A boolean value that determines whether to check
the input units and convert them to the target output
units. The \emph{safe} option is to leave this set to TRUE, but
if know for sure that the units match, modest performance gains
can be made by not checking and performing this
conversion. (default=TRUE)}

\item{check.neg.precip}{A boolean value that determines whether to
check for and eliminate negative precipitation values. Like
check.units, modest performance gains can be achieved if you
are certain that no negative precipitation values
exist. (default=TRUE)}

\item{target.units}{A list containing the units that should be used
for the output file \cr
(default=\code{c(tasmax='celsius', tasmin='celsius', pr='kg m-2 d-1')})}
}
\description{
\pkg{ClimDown} has a number of global options with sensible defaults
pre-set. Options must be configured using R's \code{\link[base]{options}}
function. They can be set by using an .Rprofile file, or on the R
session prompt prior to executing any \pkg{ClimDown} wrapper functions.
}
