% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProjectsCM.R
\name{getProjectsCM}
\alias{getProjectsCM}
\title{Get ClimMob projects}
\usage{
getProjectsCM(key, server = NULL, ...)
}
\arguments{
\item{key}{a character for the user's application programming 
interface (API) key}

\item{server}{optional, a character to select from which server
the data will be retrieved}

\item{...}{additional arguments passed to methods. See details}
}
\value{
A data frame with the ClimMob projects 
\item{project_id}{the project unique id}
\item{name}{the project name}
\item{status}{the current status}
\item{creation_date}{the project's creation date}
\item{intended_participants}{the number of participants the project 
 intended to register}
\item{registration_progress}{the percentage of intended participants 
 which were registered}
\item{last_registration_activity}{number of days since the submission 
 of the last registration}
}
\description{
Fetch the status of ClimMob projects
}
\examples{
\dontrun{ 
# This function will not work without an API key  
# the user API key can be obtained once a free ClimMob account 
# is created via https://climmob.net/

my_key <- "add_your_key"

getProjectsCM(key = my_key)

}

}
\seealso{
ClimMob website \url{https://climmob.net/}

Other GET functions: 
\code{\link{getDataCM}()}
}
\author{
Kauê de Sousa
}
\concept{GET functions}
