% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmGeoIdentity.R
\name{rmGeoIdentity}
\alias{rmGeoIdentity}
\title{Remove geographical identity}
\usage{
rmGeoIdentity(longlat, dist = 0.015, nQuadSegs = 2L, ...)
}
\arguments{
\item{longlat}{a data.frame or matrix with geographical coordinates long lat}

\item{dist}{numeric, buffer distance for all \var{lonlat}}

\item{nQuadSegs}{integer, number of segments per quadrant}

\item{...}{further arguments passed to \code{\link[sf]{sf}} methods}
}
\value{
A data frame with the random coordinates long lat within the buffer
}
\description{
Build a buffer around the a set of geographical coordinates 
 and take a random point around the buffer. The function is 
 used to omit the precise location of tricot participants 
 but keeping a close distance to the trial environment.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
xy = matrix(c(11.097799, 60.801090,
               11.161298, 60.804199,
               11.254428, 60.822457),
             nrow = 3, ncol = 2, byrow = TRUE)

rmGeoIdentity(xy)

#' the function also handles NAs

xy2 = matrix(c(11.097799, 60.801090,
                NA, NA,
                11.161298, 60.804199,
                11.254428, 60.822457,
                11.254428, NA),
              nrow = 5, ncol = 2, byrow = TRUE)

rmGeoIdentity(xy2)
\dontshow{\}) # examplesIf}
}
