% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{stability}
\alias{stability}
\title{Stability of partitions from a hierarchy of variables}
\usage{
stability(tree, B = 100, graph = TRUE)
}
\arguments{
\item{tree}{an object of class \code{hclustvar}.}

\item{B}{the number of bootstrap samples.}

\item{graph}{boolean, if 'TRUE' a graph is displayed.}
}
\value{
\item{matCR}{matrix of corrected Rand indices.}
\item{meanCR}{vector of mean corrected Rand indices.}
}
\description{
Evaluates the stability of partitions obtained from a hierarchy of \code{p}
variables. This hierarchy is performed with \code{hclustvar} and the
stability of the partitions of 2 to p-1 clusters is evaluated with a
bootstrap approach. The boostrap approch is the following: \code{hclustvar}
is applied to \code{B} boostrap samples of the \code{n} rows.  The
partitions of 2 to p-1 clusters obtained from the B bootstrap hierarchies
are compared with the partitions from the initial hierarchy . The mean of
the corrected Rand indices is plotted according to the number of clusters.
This graphical representation helps in the determination of a suitable
numbers of clusters.
}
\examples{
data(decathlon)
tree <- hclustvar(X.quanti=decathlon[,1:10])
stab<-stability(tree,B=20)
plot(stab,nmax=7)
boxplot(stab$matCR[,1:7])

}
\seealso{
\code{\link{plot.clustab}}, \code{\link{hclustvar}}
}
