\name{LCLV}
\alias{LCLV}
\title{L-CLV for L-shaped data}
\usage{
LCLV(X, Xr, Xu, ccX = FALSE, sX = TRUE, sXr = FALSE, sXu = FALSE,
  nmax = 20, graph = TRUE)
}
\arguments{
  \item{X}{The matrix of variables to be clustered}

  \item{Xr}{The external variables associated with the rows
  of X}

  \item{Xu}{The external variables associated with the
  columns of X}

  \item{ccX}{TRUE/FALSE : double centering of X (FALSE, by
  default) If FALSE this implies that cX = TRUE :
  column-centering of X}

  \item{sX}{TRUE/FALSE : standardization or not of the
  columns X (TRUE by default)}

  \item{sXr}{TRUE/FALSE : standardization or not of the
  columns Xr (FALSE by default)\cr (predefined -> cXr =
  TRUE : column-centering of Xr)}

  \item{sXu}{TRUE/FALSE : standardization or not of the
  columns Xu (FALSE by default)\cr (predefined -> cXu=
  FALSE : no centering, Xu considered as a weight matrix)}

  \item{nmax}{maximum number of partitions for which the
  consolidation will be done (by default nmax=20)}

  \item{graph}{TRUE : dendrogram and evolution of the
  aggregation criterion before and after consolidation
  (default) FALSE : no graphs}
}
\value{
\item{tabres}{ Results of the clustering algorithm.  In
each line you find the results of one specific step of the
hierarchical clustering.  \itemize{ \item {Columns 1 and
2}{ : The numbers of the two groups which are merged} \item
{Column 3}{ : Name of the new cluster} \item {Column 4}{ :
The value of the aggregation criterion for the Hierarchical
Ascendant Clustering (HAC)} \item {Column 5}{ : The value
of the clustering criterion for the HAC} \item {Column 6}{
: The percentage of the explained initial criterion value}
\item {Column 7}{ : The value of the clustering criterion
after consolidation} \item {Column 8}{ : The percentage of
the explained initial criterion value after consolidation}
\item {Column 9}{ : number of iterations in the
partitioning algorithm.\cr Remark: A zero in columns 7 to 9
indicates that no consolidation was done } }}

\item{partition K}{ a list for each number of clusters of
the partition, K=2 to nmax with \itemize{ \item {clusters}{
: in line 1, the groups membership before consolidation; in
line 2 the groups membership after consolidation} \item
{compt}{ : The latent components of the clusters (after
consolidation) defined according to the Xr variables} \item
{compc}{ : The latent components of the clusters (after
consolidation) defined according to the Xu variables} \item
{loading_v}{ : loadings of the external Xr variables (after
consolidation)} \item {loading_u}{ : loadings of the
external Xu variables (after consolidation)} }}
}
\description{
Define clusters of X-variables aroud latent components. In
each cluster, two latent components are extracted, the
first one is a linear combination of the external
information collected for the rows of X and the second one
is a linear combination of the external information
associated with the columns of X.
}
\references{
Vigneau, E., Endrizzi, I.,& Qannari, E.M. (2011). Finding
and explaining clusters of consumers using CLV approach.
Food Quality and Preference, 22, 705-713.

Vigneau, E., Charles, M.,& Chen, M. (2014). External
preference segmentation with additional information on
consumers: A case study on apples. Food Quality and
Preference, 32, 83-92.
}

