% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{plot_clustering}
\alias{plot_clustering}
\title{Graphic representation of the evaluation measures.}
\usage{
plot_clustering(df, metric)
}
\arguments{
\item{df}{data matrix or data frame with the result of running the clustering
algorithm.}

\item{metric}{it's a string with the name of the metric select to evaluate.}
}
\value{
Generate an image with the distribution of the clusters by metrics.
}
\description{
Graphical representation of the evaluation measures grouped by
cluster.
}
\details{
In certain cases the review or filtering of the data is necessary to
select the data, that is why thanks to the graphic representations this task
is much easier. Therefore with this method we will be able to filter the data
by metrics and see the data in a graphical way.
}
\examples{

result = clustering(
               df = cluster::agriculture,
               min = 4,
               max = 5,
               algorithm='gmm',
               metrics=c("Precision")
         )

plot_clustering(result,c("Precision"))

}
