% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstParmFunc.R
\name{EstParmFunc}
\alias{EstParmFunc}
\title{Writting the loglikelihood of the dirichlet}
\usage{
EstParmFunc(parms.vector, especie)
}
\arguments{
\item{parms.vector}{Vector equal to \code{c(tau,as.vector( pam))} where:

\itemize{
  \item pam:  Matrix. Each row has the parameters of each bacteria. Following our example, pam has the parameters placed as follows:
  \tabular{rrrr}{
 r1 \tab  a11  \tab  a12\cr
 r2 \tab  a21 \tab   a22 }
  \item tau:  Number. Value of the tau parameter in the model
  }}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points . The bacteria placed in the last row of this matrix is the one used as reference in the alr transfromation that the model apply}
}
\value{
Returns a number with the value of the dirichlet loglikelihood.
}
\description{
This function calculates the loglikelihood of the dirichlet for the Dirich-gLV model.
}
\details{
In an example with three bacteria, the regression of this model is defined by

\deqn{r_{1}\cdot log(x_{1}(t)/x_{3}(t))+log(x_{1}(t)/x_{3}(t))\cdot [a_{11}\cdot log(x_{1}(t)/x_{3}(t))(t)+a_{12}\cdot log(x_{2}(t)/x_{3}(t))] }
\deqn{r_{2}\cdot log(x_{2}(t)/x_{3}(t))+log(x_{2}(t)/x_{3}(t))\cdot [a_{21}\cdot log(x_{1}(t)/x_{3}(t))(t)+a_{22}\cdot log(x_{2}(t)/x_{3}(t))] }
}
\examples{


especie1=cbind(c(0.5,0.3,0.2), c(0.1,0.3,0.6))
tau1=0.4
parms1= cbind(c(0.1,0.2),c(-0.2,0.1),c(0.3,0.2))
parms11=c(tau1,as.vector( parms1))

EstParmFunc(parms11,especie1)

}
\references{
Creus-Martí, I. and Moya, A. and Santonja, F. J. (2018). A Statistical Model with a Lotka-Volterra Structure for Microbiota Data. Lucas Jodar, Juan Carlos Cortes and Luis Acedo,  Modelling or engineering and human behavior 2018, Instituto Universitario de Matematica Multidisciplinar. ISBN: 978-84-09-07541-6
}
