% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPowerTri.R
\name{plotPowerTri}
\alias{plotPowerTri}
\title{Plotting of Power versus Correlate of Risk Effect Size for Dichotomous and Trichotomous Biomarkers}
\usage{
plotPowerTri(outComputePower, outDir = NULL, legendText,
  extendedLeg = TRUE, xLegPos = 0.5, yLegPos = 0.5, ySep = 0.07,
  margin = c(7, 4, 3, 1))
}
\arguments{
\item{outComputePower}{either a list of lists containing output from \code{\link{computePower}} or a character vector specifying the \code{.RData} file(s) containing \code{\link{computePower}} output}

\item{outDir}{a character vector specifying path(s) to output \code{.RData} file(s), necessary if \code{outComputePower} is a character vector. Default is \code{NULL}.}

\item{legendText}{a character vector specifying the entirety of the legend text. The order of the elements (i.e., parameter values) must match that of the \code{\link{computePower}} input parameters in order for legend labels to be accurate.}

\item{extendedLeg}{a logical value specifying if the extended legend with additional information about the control-to-case ratio, overall vaccine efficacy, number of cases, etc., is to be included. Default is \code{TRUE}.}

\item{xLegPos}{a number from \code{0} to \code{1} specifying the horizontal position of the extended legend, if applicable. A value of \code{0} produces text on the left side of the plot, \code{0.5} (default) produces text in the center, and \code{1} produces text on the right side.}

\item{yLegPos}{a number from \code{0} to \code{1} specifying the vertical position of the extended legend, if applicable. A value of \code{0} produces text at the bottom of the plot, \code{0.5} (default) produces text in the center, and \code{1} produces text at the top.}

\item{ySep}{a numeric value that specifies the spacing distance between lines in the extended legend, if applicable. Default is \code{0.7}.}

\item{margin}{a numeric vector of the form \code{c(bottom, left, top, right)}, which specifies the margins of the plot. Default is \code{c(7, 4, 3, 1)}.}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Plots power (on the y-axis) to detect a correlate of risk effect size (on the x-axis) in the active treatment group for a dichotomous or trichotomous biomarker. The correlate of risk effect size is quantified as
the relative risk ratio of the clinical endpoint comparing subgroups of active treatment recipients with high and low biomarker response.
}
\details{
If multiple levels are specified for the biomarker measurement error input parameters (i.e., for \code{sens}/\code{spec} or \code{rho}) in \code{\link{computePower}}, only the first level is used to determine
the \eqn{RR_t} values that are plotted on the x-axis.
}
\examples{
# Example scenario with trichotomous biomarker, where values of controlCaseRatio are varied

# Set input parameters for computePower function
nCasesTx <- 10
nControlsTx <- 300
nCasesTxWithS <- 10
controlCaseRatio <- c(5,3)
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=5)
VElat1 <- rep(VEoverall, 5)
Plat0 <- P0 <- 0.2
Plat2 <- P2 <- 0.6
sens <- spec <- 0.8
FP0 <- FN2 <- 0
M <- 50
alpha <- 0.05
biomType <- "trichotomous"

# Output from computePower function is stored in an object as a list of lists
pwr <- computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
                     controlCaseRatio=controlCaseRatio, risk0=risk0,
                     VEoverall=VEoverall, Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2,
                     VElat0=VElat0, VElat1=VElat1, M=M, alpha=alpha, spec=spec,
                     FP0=FP0, sens=sens, FN2=FN2, biomType=biomType)

# Set parameters for plotPowerTri function
# outComputePower is a list of lists containing outputs from the computePower function
outComputePower <- pwr
legendText <- paste0("controls:cases = ", c("5:1","3:1"))
plotPowerTri(outComputePower=outComputePower, legendText=legendText)

\dontrun{
# outComputePower is a character vector specifying the files containing computePower output
# outDir is a character vector specifying the outComputePower file directories
outComputePower <- paste0("myFile_controlCaseRatio_", c(5, 3), ".RData")
outDir <- rep("~/myDir", 2)
legendText <- paste0("controls:cases = ", c("5:1","3:1"))
plotPowerTri(outComputePower, outDir=outDir, legendText = legendText)
}

}
\seealso{
\code{\link{computePower}}, \code{\link{plotPowerCont}}
}
