% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCodeUse.R
\name{tableCodeUse}
\alias{tableCodeUse}
\title{Format the result of summariseCodeUse into a visual table.}
\usage{
tableCodeUse(
  result,
  type = "gt",
  header = c("cdm_name", "estimate"),
  splitStrata = TRUE,
  conceptId = TRUE,
  sourceConcept = TRUE,
  groupColumns = NULL,
  excludeColumns = c("result_id", "estimate_type", "additional_name", "additional_level"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised result with results of the type "code_use".}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: \code{cdm_name}, \code{group}, \code{strata}, \code{additional},
\code{variable}, \code{estimate}, \code{settings}.}

\item{splitStrata}{If TRUE strata will be split.}

\item{conceptId}{If TRUE concept ids will be displayed.}

\item{sourceConcept}{If TRUE source concepts will be displayed.}

\item{groupColumns}{Columns to use as group labels. Allowed columns are
\code{cdm_name} and/or \code{codelist_name}.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{Named list with additional formatting options.
visOmopResults::optionsVisOmopTable() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseCodeUse result.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(),
                      dbdir = CDMConnector::eunomia_dir())
cdm <- CDMConnector::cdm_from_con(con,
                                  cdm_schem = "main",
                                  write_schema = "main")
acetiminophen <- c(1125315,  1127433, 40229134,
40231925, 40162522, 19133768,  1127078)
poliovirus_vaccine <- c(40213160)
cs <- list(acetiminophen = acetiminophen,
          poliovirus_vaccine = poliovirus_vaccine)
results <- summariseCodeUse(cs,cdm = cdm)
tableCodeUse(results)
CDMConnector::cdmDisconnect(cdm)
}

}
