% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseAchillesCodeUse.R
\name{summariseAchillesCodeUse}
\alias{summariseAchillesCodeUse}
\title{Summarise code use from achilles counts}
\usage{
summariseAchillesCodeUse(
  x,
  cdm,
  countBy = c("record", "person"),
  minCellCount = lifecycle::deprecated()
)
}
\arguments{
\item{x}{Codelist}

\item{cdm}{cdm_reference via CDMConnector::cdm_from_con()}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{minCellCount}{\verb{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}}
}
\value{
A tibble with results
}
\description{
Summarise code use from achilles counts
}
\examples{
\donttest{
cdm <- mockVocabRef("database")
oa <- getCandidateCodes(cdm = cdm, keywords = "osteoarthritis")
result_achilles <- summariseAchillesCodeUse(list(oa = oa$concept_id), cdm = cdm)
result_achilles
CDMConnector::cdmDisconnect(cdm)
}
}
