% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excludeConcepts.R
\name{excludeConcepts}
\alias{excludeConcepts}
\title{Exclude concepts from a codelist}
\usage{
excludeConcepts(x, cdm, concepts, codelistName = NULL)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{concepts}{Concepts_id to exclude}

\item{codelistName}{Name or names of codelist in x. If NULL, all codelist present
in x will be considered.}
}
\value{
A codelist
}
\description{
Exclude concepts from a codelist
}
\examples{
\donttest{
library(omock)
library(CDMConnector)

# Creating CDM object
# downloadMockDataset(datasetName = "GiBleed")
cdm <- mockCdmFromDataset(datasetName = "GiBleed")

# Creating codelist
codelist <- getDrugIngredientCodes(cdm,
                                   nameStyle = "{concept_name}")

# Exclude concept to all the codelists:
codelist$acetaminophen
codelist <- codelist |>
  excludeConcepts(cdm, concepts = c(1125315L))
codelist$acetaminophen
# Add a concept to a specific codelist
codelist$amiodarone
codelist <- codelist |>
  excludeConcepts(cdm, concepts = c(1310034L), codelistName = "amiodarone")
codelist$amiodarone

# See function: `addConcepts()` for details on how to add specific concepts
# to a codelist
}
}
