% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCohortAttrition.R
\name{tableCohortAttrition}
\alias{tableCohortAttrition}
\title{Create a visual table from the output of summariseCohortAttrition.}
\usage{
tableCohortAttrition(
  result,
  type = "gt",
  header = "variable_name",
  groupColumn = c("cdm_name", "cohort_name"),
  hide = c("variable_level", "reason_id", "estimate_name", settingsColumns(result))
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}
}
\value{
A formatted table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

result <- summariseCohortAttrition(cdm$cohort2)

tableCohortAttrition(result)

mockDisconnect(cdm)
}

}
