% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimDemographics.R
\name{trimDemographics}
\alias{trimDemographics}
\title{Restrict cohort on patient demographics}
\usage{
trimDemographics(
  cohort,
  cohortId = NULL,
  ageRange = NULL,
  sex = NULL,
  minPriorObservation = NULL,
  minFutureObservation = NULL,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{ageRange}{A list of minimum and maximum age.}

\item{sex}{Can be "Both", "Male" or "Female". If one of the latter, only
those with that sex will be included.}

\item{minPriorObservation}{A minimum number of prior observation days in
the database.}

\item{minFutureObservation}{A minimum number of future observation days in
the database.}

\item{name}{Name of the new cohort with the demographic requirements.}
}
\value{
The cohort table with only records for individuals satisfying the
demographic requirements
}
\description{
Restrict cohort on patient demographics
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(nPerson = 100)

cdm$cohort1 |> trimDemographics(ageRange = list(c(10, 30)))
}
}
