% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographicsCohort.R
\name{demographicsCohort}
\alias{demographicsCohort}
\title{Create cohorts based on patient demographics}
\usage{
demographicsCohort(
  cdm,
  name,
  ageRange = NULL,
  sex = NULL,
  minPriorObservation = NULL
)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{ageRange}{A list of vectors specifying minimum and maximum age.}

\item{sex}{Can be "Both", "Male" or "Female".}

\item{minPriorObservation}{A minimum number of continuous prior observation
days in the database.}
}
\value{
A cohort table
}
\description{
\code{demographicsCohort()} creates a cohort table based on patient
characteristics. If and when an individual satisfies all the criteria they
enter the cohort. When they stop satisfying any of the criteria their
cohort entry ends.
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor()

cohort <-  cdm |>
    demographicsCohort(name = "cohort3", ageRange = c(18,40), sex = "Male")

attrition(cohort)
}
}
