% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_presidents_list.R
\name{get_presidents_list}
\alias{get_presidents_list}
\title{Get the List of Presidents of Colombia}
\usage{
get_presidents_list()
}
\value{
A data frame with the following columns:
\itemize{
  \item \code{id}: The unique identifier of the president.
  \item \code{name}: The first name of the president.
  \item \code{lastName}: The last name of the president.
  \item \code{startPeriodDate}: The start date of the presidential period (in ISO 8601 format).
  \item \code{endPeriodDate}: The end date of the presidential period (in ISO 8601 format).
  \item \code{politicalParty}: The political party of the president.
}
}
\description{
This function retrieves the list of presidents of Colombia from the public API
"https://api-colombia.com/api/v1/President" and returns a data frame containing
selected information about each president, ordered by their start period date
in descending order (most recent first).
}
\details{
This function sends a GET request to the API, processes the JSON response,
and converts it into a structured data frame. The data is filtered and formatted
to include only relevant columns, and it is ordered by the \code{startPeriodDate} column
in descending order.

If the API returns a status code of 400, the function issues a warning message to inform
the user of the error. Any other unexpected API response is not explicitly handled and may
cause the function to fail.
}
\note{
Ensure you have an active internet connection to access the API. If the API structure changes
or the API becomes unavailable, the function may need modifications.

This function relies on the following packages: \code{httr}, \code{jsonlite}, \code{dplyr}, and \code{magrittr}.
The \code{\%>\%} operator, used for chaining commands, is provided by the \code{magrittr} package.
}
\examples{
\dontrun{
# Retrieve the list of presidents
presidents <- get_president_list()

# Print the data frame
print(presidents)

# View the data in a spreadsheet-like interface
View(presidents)

# Select presidents from a specific political party
library(dplyr)
liberal_presidents <- presidents \%>\%
  filter(politicalParty == "Liberal")
print(liberal_presidents)
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{select}},
\code{\link[dplyr]{arrange}}
}
