% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_regions_list.R
\name{get_regions_list}
\alias{get_regions_list}
\title{Get the List of Regions in Colombia}
\usage{
get_regions_list()
}
\value{
A data frame with the following columns:
\itemize{
  \item \code{id}: The unique identifier of the region.
  \item \code{name}: The name of the region.
}
}
\description{
This function retrieves a list of regions in Colombia from the public API
"https://api-colombia.com/api/v1/Region" and returns a data frame containing
selected information about each region, ordered by region name in alphabetical order.
}
\details{
This function sends a GET request to the API, processes the JSON response,
and converts it into a structured data frame. The data is filtered and formatted
to include only relevant columns (\code{id} and \code{name}), and it is ordered
by the \code{name} column in alphabetical order (A to Z).

If the API returns a status code other than 200, the function issues a message
with the status code received and returns \code{NULL}.
}
\note{
Ensure you have an active internet connection to access the API. If the API structure changes
or the API becomes unavailable, the function may need modifications.

This function relies on the following packages: \code{httr}, \code{jsonlite}, \code{dplyr}, and \code{magrittr}.
The \code{\%>\%} operator, used for chaining commands, is provided by the \code{magrittr} package.
}
\examples{
\dontrun{
# Retrieve the list of regions
regions <- get_regions_list()

# Print the data frame
print(regions)

# View the data in a spreadsheet-like interface
View(regions)

# Select regions with specific characteristics (e.g., starting with "Atlántico")
atlantic_regions <- regions \%>\%
  filter(grepl("^Atlántico", name))
print(atlantic_regions)
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{select}},
\code{\link[dplyr]{arrange}}
}
