% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{apply_norm}
\alias{apply_norm}
\title{Automatically applies a normalization to either an input or output}
\usage{
apply_norm(df, norm, names, input, values, model_control)
}
\arguments{
\item{df}{The data.table with columns to be normalized}

\item{norm}{The normalization option used, currently max or mean}

\item{names}{columns for elements of the model, used to identify data columns}

\item{input}{boolean if the normalization is being performed on the input values or on an output}

\item{values}{list of values using during normalization}

\item{model_control}{controls which alternative model options are used, see the Control_Options vignette for further details}
}
\value{
returns list with the normalized values
}
\description{
\code{apply_norm} applies a normalization factor
}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Iters}()},
\code{\link{Date_Shift}()},
\code{\link{Event_Count_Gen}()},
\code{\link{Event_Time_Gen}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{gen_time_dep}()}
}
\concept{Data Cleaning Functions}
