% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_prep.R
\name{visual_prep}
\alias{visual_prep}
\title{Batch Effect Diagnostic Visualization Preparation}
\usage{
visual_prep(
  type = "lm",
  features,
  batch,
  covariates = NULL,
  interaction = NULL,
  random = NULL,
  smooth = NULL,
  smooth_int_type = NULL,
  df,
  cores = detectCores(),
  mdmr = TRUE
)
}
\arguments{
\item{type}{The name of a regression model to be used in batch effect diagnostics stage: \code{"lmer"}, \code{"lm"}, \code{"gam"}.}

\item{features}{The name of the features to be evaluated.}

\item{batch}{The name of the batch variable.}

\item{covariates}{Name of covariates supplied to \code{model}.}

\item{interaction}{Expression of interaction terms supplied to \code{model} (eg: \code{"age,diagnosis"}).}

\item{random}{Variable name of a random effect in linear mixed effect model.}

\item{smooth}{Variable name that requires a smooth function.}

\item{smooth_int_type}{Indicates the type of interaction in \code{gam} models. By default, \code{smooth_int_type} is set to be \code{"linear"}, representing linear interaction terms.
\code{"categorical-continuous"}, \code{"factor-smooth"} both represent categorical-continuous interactions (\code{"factor-smooth"} includes categorical variable as part of the smooth),
\code{"tensor"} represents interactions with different scales, and \code{"smooth-smooth"} represents interaction between smoothed variables.}

\item{df}{Dataset to be evaluated.}

\item{cores}{number of cores used for parallel computing.}

\item{mdmr}{A boolean variable indicating whether to run the MDMR test (default: \code{TRUE}).}
}
\value{
\code{visual_prep} returns a list containing the following components:
\item{residual_add_df}{Residuals that might contain additive and multiplicative joint batch effects}
\item{residual_ml_df}{Residuals that might contain multiplicative batch effect}
\item{pr.feature}{PCA results}
\item{pca_summary}{A dataframe containing the variance explained by Principal Components (PCs)}
\item{pca_df}{A dataframe contains features in the form of PCs}
\item{tsne_df}{A dataframe prepared for T-SNE plots}
\item{kr_test_df}{A dataframe contains Kenward-Roger(KR) test results}
\item{fk_test_df}{A dataframe contains Fligner-Killeen(FK) test results}
\item{mdmr.summary}{A dataframe contains MDMR results}
\item{anova_test_df}{A dataframe contains ANOVA test results}
\item{kw_test_df}{A dataframe contains Kruskal-Wallis test results}
\item{lv_test_df}{A dataframe contains Levene's test results}
\item{bl_test_df}{A dataframe contains Bartlett's test results}
\item{red}{A parameter to highlight significant p-values in result table}
\item{info}{A list contains input information like batch, covariates, df etc}
}
\description{
Prepare relevant datasets and statistical test results for batch/site effect diagnostic visualization.
}
\examples{
visual_prep(type = "lm", features = colnames(adni)[43:53], batch = "manufac",
covariates = c("AGE", "SEX", "DIAGNOSIS"), df = head(adni, 500), cores = 1)

}
