/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.cache;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JLaTeXMathCache {
    private static final AffineTransform identity = new AffineTransform();
    private static ConcurrentMap<CachedTeXFormula, SoftReference<CachedImage>> cache = new ConcurrentHashMap<CachedTeXFormula, SoftReference<CachedImage>>(128);
    private static int max = Integer.MAX_VALUE;
    private static ReferenceQueue queue = new ReferenceQueue();

    private JLaTeXMathCache() {
    }

    public static void setMaxCachedObjects(int max) {
        JLaTeXMathCache.max = Math.max(max, 1);
        cache.clear();
        cache = new ConcurrentHashMap<CachedTeXFormula, SoftReference<CachedImage>>(JLaTeXMathCache.max);
    }

    public static int[] getCachedTeXFormulaDimensions(String f, int style, int size, int inset) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaDimensions(new CachedTeXFormula(f, style, size, inset));
    }

    public static int[] getCachedTeXFormulaDimensions(Object o) throws ParseException {
        if (o == null || !(o instanceof CachedTeXFormula)) {
            return new int[]{0, 0, 0};
        }
        CachedTeXFormula cached = (CachedTeXFormula)o;
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        return new int[]{cached.width, cached.height, cached.depth};
    }

    public static Object getCachedTeXFormula(String f, int style, int size, int inset) throws ParseException {
        CachedTeXFormula cached = new CachedTeXFormula(f, style, size, inset);
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        return cached;
    }

    public static void clearCache() {
        cache.clear();
    }

    public static void removeCachedTeXFormula(String f, int style, int size, int inset) throws ParseException {
        cache.remove(new CachedTeXFormula(f, style, size, inset));
    }

    public static void removeCachedTeXFormula(Object o) throws ParseException {
        if (o == null || o instanceof CachedTeXFormula) {
            cache.remove((CachedTeXFormula)o);
        }
    }

    public static Object paintCachedTeXFormula(String f, int style, int size, int inset, Graphics2D g) throws ParseException {
        return JLaTeXMathCache.paintCachedTeXFormula(new CachedTeXFormula(f, style, size, inset), g);
    }

    public static Object paintCachedTeXFormula(Object o, Graphics2D g) throws ParseException {
        if (o == null || !(o instanceof CachedTeXFormula)) {
            return null;
        }
        CachedTeXFormula cached = (CachedTeXFormula)o;
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        g.drawImage(img.get().image, identity, null);
        return cached;
    }

    public static Image getCachedTeXFormulaImage(String f, int style, int size, int inset) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaImage(new CachedTeXFormula(f, style, size, inset));
    }

    public static Image getCachedTeXFormulaImage(Object o) throws ParseException {
        if (o == null || !(o instanceof CachedTeXFormula)) {
            return null;
        }
        CachedTeXFormula cached = (CachedTeXFormula)o;
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        return img.get().image;
    }

    private static SoftReference<CachedImage> makeImage(CachedTeXFormula cached) throws ParseException {
        TeXFormula formula = new TeXFormula(cached.f);
        TeXIcon icon = formula.createTeXIcon(cached.style, cached.size);
        icon.setInsets(new Insets(cached.inset, cached.inset, cached.inset, cached.inset));
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        icon.paintIcon(null, g2, 0, 0);
        g2.dispose();
        cached.setDimensions(icon.getIconWidth(), icon.getIconHeight(), icon.getIconDepth());
        SoftReference<CachedImage> img = new SoftReference<CachedImage>(new CachedImage(image, cached), queue);
        if (cache.size() >= max) {
            Reference soft;
            while ((soft = queue.poll()) != null) {
                CachedImage ci = (CachedImage)soft.get();
                if (ci == null) continue;
                cache.remove(ci.cachedTf);
            }
            Iterator iter = cache.keySet().iterator();
            if (iter.hasNext()) {
                CachedTeXFormula c = (CachedTeXFormula)iter.next();
                ((SoftReference)cache.get(c)).clear();
                cache.remove(c);
            }
        }
        cache.put(cached, img);
        return img;
    }

    private static class CachedTeXFormula {
        String f;
        int style;
        int size;
        int inset;
        int width = -1;
        int height;
        int depth;

        CachedTeXFormula(String f, int style, int size, int inset) {
            this.f = f;
            this.style = style;
            this.size = size;
            this.inset = inset;
        }

        void setDimensions(int width, int height, int depth) {
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof CachedTeXFormula) {
                boolean b;
                CachedTeXFormula c = (CachedTeXFormula)o;
                boolean bl = b = c.f.equals(this.f) && c.style == this.style && c.size == this.size && c.inset == this.inset;
                if (b) {
                    if (c.width == -1) {
                        c.width = this.width;
                        c.height = this.height;
                        c.depth = this.depth;
                    } else if (this.width == -1) {
                        this.width = c.width;
                        this.height = c.height;
                        this.depth = c.depth;
                    }
                }
                return b;
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode();
        }
    }

    private static class CachedImage {
        Image image;
        CachedTeXFormula cachedTf;

        CachedImage(Image image, CachedTeXFormula cachedTf) {
            this.image = image;
            this.cachedTf = cachedTf;
        }
    }
}

