% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressure.R
\name{pressure}
\alias{pressure}
\title{The pressure vessel computer model}
\usage{
pressure(x1, x2, x3, x4)
}
\arguments{
\item{x1}{A scalar value between 0 and 99, inclusive, controlling the thickness of the shell.}

\item{x2}{A scalar value between 0 and 99, inclusive, controlling the thickness of the head.}

\item{x3}{A scalar value between 0 and 200, inclusive, controlling the inner radius.}

\item{x4}{A scalar value between 0 and 200, inclusive, controlling the length of the cylindrical section of the vessel (x4) not including the head.}
}
\value{
The evaluation of running the tension spring computer model at input (x1, x2, x3).
\itemize{
  \item obj:  A scalar objective function value
  \item con:  A vector of constraint function values
}
}
\description{
The pressure vessel computer model is designed to minimize the total cost of constructing a pressure vessel considering the cost of material, forming, and welding.
The four inputs to the computer model are the thickness of the shell (x1), the thickness of the head (x2), the inner radius (x3), and the length of the cylindrical section of the vessel (x4) not including the head.
Note, the thicknesses of the variables are integer multiples of 0.0625 inches. The cost of the pressure vessel is subject to four constraints.
}
\note{
A solution is feasible only if of all of the constraint functions values are less than or equal to 0.
}
\examples{
### Running the function at x1 = 10, x2 = 4, x3 = 21, x4 = 24.
### obj = 55536.1 and con = (-10.4053, -20.77104, 12223956.99727, -216)
### (x1,x2,x3,x4) = (10,4,21,24) is not a feasible solution

pressure(10,4,21,24)
}
