% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgraph.conNEcT.R
\name{qgraph.conNEcT}
\alias{qgraph.conNEcT}
\title{Draws a Network figure}
\usage{
qgraph.conNEcT(x, signOnly = TRUE, ...)
}
\arguments{
\item{x}{A conNEcT-object}

\item{signOnly}{Logic indicating whether significant links should be depicted (TRUE; default) or not (FALSE)}

\item{...}{Parameter settings for qgraph}
}
\value{
A network plot
}
\description{
Draws a Network figure
}
\examples{
ADOangry=rep(c(1,1,1,1,1,0,0,0,0,0),100)
MAangry=rep(c(0,0,1,1,1,1,0,0,0,0),100)
MAsad=rep(c(0,0,1,1,1,1,0,0,0,0),100)
netdata <- cbind(ADOangry,MAangry,MAsad)
netnet <- conNEcT(netdata,lag=1,conFun=funKappa,
                           test=TRUE,nBlox=5)
qgraph.conNEcT(netnet,signOnly=FALSE)
}
