% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsZIC.test.R
\name{tsZIC.test}
\alias{tsZIC.test}
\title{Test whether two ZIC values differ significantly based on minimum ZIC for time series data}
\usage{
tsZIC.test(x,model1,model2,model_ZIC="AIC",alpha=0.05)
}
\arguments{
\item{x}{time series data (maximum of 1000 data points).}

\item{model1}{AR and MA coefficients of Model 1.}

\item{model2}{AR and MA coefficients of Model 2.}

\item{model_ZIC}{type of the information criterion, it can be "AIC", "BIC", or "AICc" (Default is the "AIC").}

\item{alpha}{significance level \eqn{\alpha} for the hypothesis testing (Default is 0.05).}
}
\value{
p-value with significance status.
}
\description{
Test whether two ZIC values differ significantly based on minimum ZIC for time series data.
}
\details{
Consider the hypothesis: Under the null hypothesis that the two expected discrepancies are equal.

\deqn{H_0: ZIC_i=ZIC_j      ,    H_1: ZIC_i\neq ZIC_j}

\deqn{Z_0=\frac{(\hat{ZIC_i}-\hat{ZIC_j})-0}{\sqrt{SD(ZIC_i,ZIC_j)}} \sim N(0,1)}  is calculated empirically.
}
\examples{
library(ConfZIC)
data(Sunspots)
x=Sunspots
model1=try(arima(x,order=c(1,0,1),method="ML",include.mean=FALSE),silent = TRUE)
model2=try(arima(x,order=c(1,0,0),method="ML",include.mean=FALSE),silent = TRUE)
tsZIC.test(x,model1,model2,model_ZIC="AIC",alpha=0.05)
}
\references{
Linhart, H. (1988). A test whether two AIC's differ significantly. South African Statistical Journal, 22(2), 153-161.
}
