% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRF.R
\name{IRF}
\alias{IRF}
\title{Impulse response functions}
\usage{
IRF(Phi, Sigma, nfore = 10, orth = TRUE)
}
\arguments{
\item{Phi}{VAR coefficient matrix}

\item{Sigma}{Residual Variance-Covariance Matrix}

\item{nfore}{H-step ahead forecast horizon}

\item{orth}{Boolean}
}
\value{
Orthorgonal/generalized time/frequency impulse response functions
}
\description{
This function calculates orthorgonalized/generalized impulse response functions of time or frequency domain.
}
\examples{
data(dy2012)
fit = VAR(dy2012, configuration=list(nlag=1))
irf = IRF(Phi=fit$B, Sigma=fit$Q, nfore=10, orth=TRUE)
}
\references{
Stiassny, A. (1996). A spectral decomposition for structural VAR models. Empirical Economics, 21(4), 535-555.

Koop, G., Pesaran, M. H., & Potter, S. M. (1996). Impulse response analysis in nonlinear multivariate models. Journal of Econometrics, 74(1), 119-147.

Pesaran, H. H., & Shin, Y. (1998). Generalized impulse response analysis in linear multivariate models. Economics Letters, 58(1), 17-29.
}
\author{
David Gabauer
}
