% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBFULL.R
\name{BBFULL}
\alias{BBFULL}
\title{Branch-and-Bound algorithm to find the median ranking in the space of full (or complete) rankings.}
\usage{
BBFULL(X, Wk = NULL, PS = TRUE)
}
\arguments{
\item{X}{A N by M data matrix, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. The data matrix can contain both full and tied rankings, or incomplete rankings. Alternatively X can contain the rankings observed only once. In this case the argument Wk must be used}

\item{Wk}{Optional: the frequency of each ranking in the data}

\item{PS}{If PS=TRUE, on the screen some information about how many branches are processed are displayed}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Consensus \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged TauX rank correlation coefficient\cr
Eltime\tab   \tab Elapsed time in seconds}
}
\description{
Branch-and-bound algorithm to find consensus ranking as definned by D'Ambrosio et al. (2015). If the number of objects to be ranked is large (greater than 20 or 25), it can work for very long time. Use either QuickCons or FASTcons with the option FULL=TRUE instead
}
\details{
If the objects to be ranked is large (>25 - 30), it can take long time to find the solutions
}
\examples{
data(APAFULL)
CR=BBFULL(APAFULL)

}
\references{
D'Ambrosio, A., Amodio, S., and Iorio, C. (2015). Two algorithms for finding optimal solutions of the Kemeny rank aggregation problem for full rankings. Electronic Journal of Applied Statistical Analysis, 8(2), 198-213.
}
\seealso{
\code{\link{FASTcons}} FAST algorithm algorithm.

\code{\link{QuickCons}} Quick algorithm.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Median}
\keyword{ranking}
