% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consrank.R
\name{consrank}
\alias{consrank}
\title{Branch-and-bound and heuristic algorithms to find consensus (median) ranking according to the Kemeny's axiomatic approach}
\usage{
consrank(
  X,
  wk = NULL,
  ps = TRUE,
  algorithm = "BB",
  full = FALSE,
  itermax = 10,
  np = 15,
  gl = 100,
  ff = 0.4,
  cr = 0.9,
  proc = FALSE
)
}
\arguments{
\item{X}{A n by m data matrix, in which there are n judges and m objects to be judged. Each row is a ranking of the objects which are represented by the columns. If X contains the rankings observed only once, the argument wk can be used}

\item{wk}{Optional: the frequency of each ranking in the data}

\item{ps}{If PS=TRUE, on the screen some information about how many branches are processed are displayed.}

\item{algorithm}{Specifies the used algorithm. One among "BB", "Quick", "FAST" and "DECOR". algorithm="BB" is the default option.}

\item{full}{Specifies if the median ranking must be searched in the universe of rankings including all the possible ties (full=FALSE) or in the restricted space of full rankings (permutations). full=FALSE is the default option.}

\item{itermax}{maximum number of iterations for FAST and DECOR algorithms. itermax=10 is the default option.}

\item{np}{For DECOR algorithm only: the number of population individuals. np=15 is the default option.}

\item{gl}{For DECOR algorithm only: generations limit, maximum number of consecutive generations without improvement. gl=100 is the default option.}

\item{ff}{For DECOR algorithm only: the scaling rate for mutation. Must be in [0,1]. ff=0.4 is the default option.}

\item{cr}{For DECOR algorithm only: the crossover range. Must be in [0,1]. cr=0.9 is the default option.}

\item{proc}{For BB algorithm only: proc=TRUE allows the branch and bound algorithm to work in difficult cases, i.e. when the number of objects is larger than 15 or 25. proc=FALSE is the default option}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Consensus \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged TauX rank correlation coefficient\cr
Eltime\tab   \tab Elapsed time in seconds}#'
}
\description{
Branch-and-bound, Quick , FAST and DECOR algorithms to find consensus (median) ranking according to the Kemeny's axiomatic approach. The median ranking(s) can be restricted to be necessarily a full ranking, namely without ties
}
\details{
The BB algorithm can take long time to find the solutions if the number objects to be ranked is 
large with some missing (>15-20 if full=FALSE, <25-30 if full=TRUE). 
quick algorithm works with a large number of items to be ranked. The solution is quite accurate. 
fast algorithm works with a large number of items to be ranked by repeating several times the quick algorithm with different random starting points.
decor algorithm works with a very large number of items to be ranked. 
For decor algorithm, empirical evidence shows that the number of population individuals (the 'np' parameter) can be set equal to 10, 20 or 30
for problems till 20, 50 and 100 items. Both scaling rate and crossover ratio (parameters
'ff' and 'cr') must be set by the user. The default options (ff=0.4, cr=0.9) work well
for a large variety of data sets
All algorithms allow the user to set the option 'full=TRUE' if the median ranking(s) must be searched in the restricted space of permutations instead of in the unconstrained universe of rankings of n items including all possible ties
}
\examples{
data(Idea)
RevIdea<-6-Idea 
# as 5 means "most associated", it is necessary compute the reverse ranking of 
# each rankings to have rank 1 = "most associated" and rank 5 = "least associated"
CR<-consrank(RevIdea)
CR<-consrank(RevIdea,algorithm="quick")
#CR<-consrank(RevIdea,algorithm="fast",itermax=10)
#not run
#data(EMD)
#CRemd<-consrank(EMD[,1:15],wk=EMD[,16],algorithm="decor",itermax=1)
#data(APAFULL)
#CRapa<-consrank(APAFULL,full=TRUE)


}
\references{
Emond, E. J., and Mason, D. W. (2002). A new rank correlation coefficient with application to the consensus ranking problem. Journal of Multi-Criteria Decision Analysis, 11(1), 17-28.
D'Ambrosio, A., Amodio, S., and Iorio, C. (2015). Two algorithms for finding optimal solutions of the Kemeny rank aggregation problem for full rankings. Electronic Journal of Applied Statistical Analysis, 8(2), 198-213.
Amodio, S., D'Ambrosio, A. and Siciliano, R. (2016). Accurate algorithms for identifying the median ranking when dealing with weak and partial rankings under the Kemeny axiomatic approach. European Journal of Operational Research, 249(2), 667-676.
D'Ambrosio, A., Mazzeo, G., Iorio, C., and Siciliano, R. (2017). A differential evolution algorithm for finding the median ranking under the Kemeny axiomatic approach. Computers and Operations Research, vol. 82, pp. 126-138.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Branch-and-bound}
\keyword{Consensus}
\keyword{Differential}
\keyword{Fast}
\keyword{Genetic}
\keyword{Median}
\keyword{Quick}
\keyword{algorithm}
\keyword{algorithms}
\keyword{evolution}
\keyword{ranking}
