% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univranks.R
\name{univranks}
\alias{univranks}
\title{Generate the universe of rankings}
\usage{
univranks(X, k = NULL, ordering = TRUE)
}
\arguments{
\item{X}{A ranking, an ordering, a matrix of rankings, a matrix of orderings or a number}

\item{k}{Optional: the number of the non-empty subsets. It has to be used only if X is anumber. The default value is NULL, In this case the universe of rankings with n=X items are computed}

\item{ordering}{The universe of rankings must be returned as orderings (default) or rankings?}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Runiv \tab  \tab The universe of rankings\cr
Cuniv \tab       \tab A list containing:\cr
 \tab R   \tab The universe of rankings in terms of rankings;\cr
 \tab Parts \tab for each ranking in input the produced rankings\cr
 \tab Univinbuckets \tab the universe of rankings within each bucket}
}
\description{
Generate the universe of rankings given the input partition
}
\details{
The function should be used with small numbers because it can generate a large number of permutations. The use of X greater than 9, of X matrices with more than 9 columns as input is not reccomended.
}
\examples{
S2<-stirling2(4,4)$SM[4,] #indicates in how many ways 4 objects
                         #can be placed, respectively, into 1, 2,
                         #3 or 4 non-empty subsets.
CardConstr<-factorial(c(1,2,3,4))*S2  #the cardinality of rankings 
                                     #constrained into 1, 2, 3 and 4
                                     #buckets
Card<-sum(CardConstr)  #Cardinality of the universe of rankings with 4
                      #objects                                                              
U<-univranks(4)$Runiv #the universe of rankings with four objects
                     # we know that the universe counts 75 
                     #different rankings
Uk<-univranks(4,2)$Runiv    #the universe of rankings of four objects 
                           #constrained into k=2 buckets, we know they are 14
Up<-univranks(c(1,4,3,1))$Runiv  #the universe of rankings with 4 objects
                                #for which the first and the fourth item
                                #are tied

}
\seealso{
\code{\link{stirling2}} Stirling number of second kind.

\code{\link{rank2order}} Convert rankings into orderings.

\code{\link{order2rank}} Convert orderings into ranks.

\code{\link{partitions}} Generate partitions of n items constrained into k non empty subsets.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
