% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_generation_functions.R
\name{gaussian_clusters_with_param}
\alias{gaussian_clusters_with_param}
\title{Generate clusters of data points from Gaussian distribution with given parameters}
\usage{
gaussian_clusters_with_param(n, center, sigma)
}
\arguments{
\item{n}{vector of number of data points in each cluster
The length of \code{n} should be equal to the number of clusters.}

\item{center}{matrix of centers Ncluster x dim}

\item{sigma}{list of covariance matrices dim X dim.
The length of sigma should be equal to the number of clusters.}
}
\value{
matrix of Nsamples x (dim + 1). The last column is cluster labels.
}
\description{
Generate clusters of data points from Gaussian distribution with given parameters
}
\examples{
center = rbind(c(0,0),
               c(1,1))
sigma = list(diag(c(1,1)),
             diag(2,2))
gaussian_clusters_with_param(c(10, 10), center, sigma)

}
