% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeH.R
\name{computeH}
\alias{computeH}
\title{Compute H values}
\usage{
computeH(X, id)
}
\arguments{
\item{X}{matrix or dataframe containing data (preferably filtered, in order to remove business cycles)}

\item{id}{optional; row index of regions for which H values are to be computed;
if missing, all regions are used}
}
\value{
A numeric vector
}
\description{
Computes H values (cross sectional variance) according to the clustering
algorithm by Phillips and Sul (2007, 2009)
}
\details{
The cross sectional variation \eqn{H_{it}}{H(it)} is computed as the quadratic
         distance measure for the panel from the common limit and under the
         hypothesis of the model should converge to zero as \emph{t} tends towards infinity:
             \deqn{H_t = N^{-1} \sum_{i=1}^N (h_{it}-1)^2 \rightarrow 0 , \quad   t\rightarrow \infty}{
                  H(t) = 1/N \sum [h(it)-1]^2 --> 0  	as   t -> infinity  }
         where
             \deqn{h_{it} = \frac{\log y_{it}}{( N^{-1} \sum_{i=1}^N log \, y_{it} )} }{
                  h(it) = N log[y(it)] / \sum log[y(it)]    }
}
\references{
Phillips, P. C.; Sul, D., 2007. Transition modeling and econometric convergence tests. Econometrica 75 (6), 1771-1855.

Phillips, P. C.; Sul, D., 2009. Economic transition and growth. Journal of Applied Econometrics 24 (7), 1153-1185.
}
